% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{export_dt}
\alias{export_dt}
\alias{export_df}
\alias{export_pval}
\alias{export_binary}
\alias{export_af}
\title{Export the mutation matrix}
\usage{
export_dt(mtmutObj, percent_interp = 1, n_interp = 3, all_cell = FALSE)

export_df(mtmutObj, ...)

export_pval(mtmutObj, memoSort = TRUE, ...)

export_binary(mtmutObj, memoSort = TRUE, ...)

export_af(mtmutObj, memoSort = TRUE, ...)
}
\arguments{
\item{mtmutObj}{The scMtioMut object.}

\item{percent_interp}{A numeric value, the overlapping percentage threshold for triggering interpolation. The default is 1, which means no interpolation.}

\item{n_interp}{A integer value, the minimum number of overlapped cells with mutation for triggering interpolation, the default is 3.}

\item{all_cell}{A boolean to indicate whether to include all cells or only cells with mutation. By default, only cells with mutation are included.}

\item{...}{Other parameters passed to \code{\link{export_dt}} or \code{\link{export_df}}.}

\item{memoSort}{A boolean to indicate whether to sort the loci by mutation frequency. The default is TRUE, the advanced user will know when to set it to FALSE.}
}
\value{
data.frame, data.table or matrix or p
}
\description{
The helper functions to export the mutation results for further analysis. The output format can be data.frame, data.table or matrix for p value, allele frequency or binary mutation status.
}
\examples{
## Use the example data
f <- system.file("extdata", "mini_dataset.tsv.gz", package = "scMitoMut")

## Create a temporary h5 file
## In real case, we keep the h5 in project folder for future use
f_h5_tmp <- tempfile(fileext = ".h5")

## Load the data with parse_table function
f_h5 <- parse_table(f, sep = "\t", h5_file = f_h5_tmp)
## open the h5 file and create a mtmutObj object
x <- open_h5_file(f_h5)
run_model_fit(x)
x <- filter_loc(x, min_cell = 5, model = "bb", p_threshold = 0.05, p_adj_method = "fdr")
x
export_df(x)
export_pval(x)
export_af(x)
export_binary(x)
}
