% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_sim.R
\name{gen_1branch}
\alias{gen_1branch}
\title{Generate true transcript counts for linear structure}
\usage{
gen_1branch(
  kinet_params,
  start_state,
  start_s,
  start_u,
  randpoints1,
  ncells1,
  ngenes,
  beta_vec,
  d_vec,
  cycle_length_factor,
  cell
)
}
\arguments{
\item{kinet_params}{kinetic parameters, include k_on, k_off, s and beta}

\item{start_state}{the starting state: on or off of each gene}

\item{start_s}{spliced count of the root cell in the branch}

\item{start_u}{unspliced count of the root cell in the branch}

\item{randpoints1}{the value which evf mean is generated from}

\item{ncells1}{number of cells in the branch}

\item{ngenes}{number of genes}

\item{beta_vec}{splicing rate of each gene}

\item{d_vec}{degradation rate of each gene}

\item{cycle_length_factor}{for generating velocity data, a factor which is multiplied by the expected time to transition from kon to koff and back to to form the the length of a cycle}

\item{cell}{the cell number currently having counts generated}
}
\value{
a list of 4 elements, the first element is true counts, second is the gene level meta information, the third is cell level meta information, including a matrix of evf and a vector of cell identity, and the fourth is the parameters kon, koff and s used to simulation the true counts
}
\description{
Generate true transcript counts for linear structure
}
\keyword{internal}
