% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_main.R
\name{sim_true_counts}
\alias{sim_true_counts}
\title{Simulate true scRNA and scATAC counts from the parameters}
\usage{
sim_true_counts(options, return_summarized_exp = FALSE)
}
\arguments{
\item{options}{See scMultiSim_help().}

\item{return_summarized_exp}{Whether to return a SummarizedExperiment object.}
}
\value{
scMultiSim returns an environment with the following fields:
\itemize{
\item \code{counts}: Gene-by-cell scRNA-seq counts.
\item \code{atac_counts}: Region-by-cell scATAC-seq counts.
\item \code{region_to_gene}: Region-by-gene 0-1 marix indicating the corresponding relationship between chtomatin regions and genes.
\item \code{atacseq_data}: The "clean" scATAC-seq counts without added intrinsic noise.
\item \code{cell_meta}: A dataframe containing cell type labels and pseudotime information.
\item \code{cif}: The CIF used during the simulation.
\item \code{giv}: The GIV used during the simulation.
\item \code{kinetic_params}: The kinetic parameters used during the simulation.
\item \code{.grn}: The GRN used during the simulation.
\item \code{.grn$regulators}: The list of TFs used by all gene-by-TF matrices.
\item \code{.grn$geff}: Gene-by-TF matrix representing the GRN used during the simulation.
\item \code{.n}: Other metadata, e.g. \code{.n$cells} is the number of cells.
}

If \code{do.velocity} is enabled, it has these additional fields:
\itemize{
\item \code{unspliced_counts}: Gene-by-cell unspliced RNA counts.
\item \code{velocity}: Gene-by-cell RNA velocity ground truth.
\item \code{cell_time}: The pseudotime at which the cell counts were generated.
}

If dynamic GRN is enabled, it has these additional fields:
\itemize{
\item \code{cell_specific_grn}: A list of length \code{n_cells}. Each element is a gene-by-TF matrix, indicating the cell's GRN.
}

If cell-cell interaction is enabled, it has these additional fields:
\itemize{
\item \code{grid}: The grid object used during the simulation.
\itemize{
\item \code{grid$get_neighbours(i)}: Get the neighbour cells of cell \code{i}.
}
\item \code{cci_locs}: A dataframe containing the X and Y coordinates of each cell.
\item \code{cci_cell_type_param}: A dataframe containing the CCI network ground truth: all ligand-receptor pairs between each pair of cell types.
\item \code{cci_cell_types}: For continuous cell population, the sub-divided cell types along the trajectory used when simulating CCI.
}

If it is a debug session (\code{debug = TRUE}), a \code{sim} field is available,
which is an environment contains all internal states and data structures.
}
\description{
Simulate true scRNA and scATAC counts from the parameters
}
\examples{
data(GRN_params_100, envir = environment())
sim_true_counts(list(
  rand.seed = 0,
  GRN = GRN_params_100,
  num.cells = 100,
  num.cifs = 50,
  tree = Phyla5()
))
}
