% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomart_methods.R
\name{convert_geneid}
\alias{convert_geneid}
\title{convert the gene ids of a SingleCellExperiment object}
\usage{
convert_geneid(sce, returns = "external_gene_name", all = TRUE)
}
\arguments{
\item{sce}{a SingleCellExperiment object}

\item{returns}{the gene id which is set as return. Default to be `external_gene_name`
A possible list of attributes can be retrieved using the
function \code{listAttributes} from \code{biomaRt} package. The commonly used
id types are `external_gene_name`, `ensembl_gene_id` or `entrezgene`.}

\item{all}{logic. For genes that cannot covert to new gene id, keep them with the old
id or delete them. The default is keep them.}
}
\value{
sce with converted id
}
\description{
convert the gene ids of a SingleCellExperiment object
}
\details{
convert the gene id of all datas in the SingleCellExperiment object
}
\examples{
# the gene id in example data are `external_gene_name`
# the following example will convert it to `external_gene_name`.
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts = as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication
head(rownames(sce))
sce = convert_geneid(sce, return="external_gene_name")
head(rownames(sce))

}
