% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalBias.R
\name{clonalBias}
\alias{clonalBias}
\title{Calculate Clonal Bias Towards a Cluster or Compartment}
\usage{
clonalBias(
  sc.data,
  cloneCall = "strict",
  split.by = NULL,
  group.by = NULL,
  n.boots = 20,
  min.expand = 10,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{sc.data}{The single-cell object after \code{\link[=combineExpression]{combineExpression()}}.}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{split.by}{The variable to use for calculating the baseline frequencies.
For example, "Type" for lung vs peripheral blood comparison}

\item{group.by}{A column header in the metadata that bias will be based on.}

\item{n.boots}{number of bootstraps to downsample.}

\item{min.expand}{clone frequency cut off for the purpose of comparison.}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}.}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
ggplot scatter plot with clone bias
}
\description{
The metric seeks to quantify how individual clones are skewed towards
a specific cellular compartment or cluster. A clone bias of \code{1} -
indicates that a clone is composed of cells from a single
compartment or cluster, while a clone bias of \code{0} - matches the
background subtype distribution. Please read and cite the following
\href{https://pubmed.ncbi.nlm.nih.gov/35829695/}{manuscript}
if using \code{\link[=clonalBias]{clonalBias()}}.
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Getting a sample of a Seurat object
scRep_example <- get(data("scRep_example"))

# Using combineExpresion()
scRep_example <- combineExpression(combined, scRep_example)
scRep_example$Patient <- substring(scRep_example$orig.ident,1,3)

# Using clonalBias()
clonalBias(scRep_example, 
              cloneCall = "aa", 
              split.by = "Patient", 
              group.by = "seurat_clusters",
              n.boots = 5, 
              min.expand = 2)


}
\concept{SC_Functions}
