% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineExpression.R
\name{combineExpression}
\alias{combineExpression}
\title{Adding Clonal Information to Single-Cell Object}
\usage{
combineExpression(
  input.data,
  sc.data,
  cloneCall = "strict",
  chain = "both",
  group.by = NULL,
  proportion = TRUE,
  filterNA = FALSE,
  cloneSize = c(Rare = 1e-04, Small = 0.001, Medium = 0.01, Large = 0.1, Hyperexpanded =
    1),
  addLabel = FALSE
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}}, \code{\link[=combineBCR]{combineBCR()}} or a list of
both c(\code{\link[=combineTCR]{combineTCR()}}, \code{\link[=combineBCR]{combineBCR()}}).}

\item{sc.data}{The Seurat or Single-Cell Experiment (SCE) object to attach}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL}
(for both light chains), \code{both}.}

\item{group.by}{A column header in lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, will be based on the list element.}

\item{proportion}{Whether to proportion (\code{TRUE}) or total
frequency (\code{FALSE}) of the clone based on the group.by variable.}

\item{filterNA}{Method to subset Seurat/SCE object of barcodes without
clone information}

\item{cloneSize}{The bins for the grouping based on proportion or frequency.
If proportion is \code{FALSE} and the cloneSizes are not set high enough
based on frequency, the upper limit of cloneSizes will be automatically
updated.S}

\item{addLabel}{This will add a label to the frequency header, allowing
the user to try multiple group.by variables or recalculate frequencies after
subsetting the data.}
}
\value{
Single-cell object with clone information added to meta data
information
}
\description{
This function adds the immune receptor information to the Seurat or
SCE object to the meta data. By default this function also calculates
the frequencies and proportion of the clones by sequencing
run (\code{group.by} = NULL). To change how the frequencies/proportions
are calculated, select a column header for the \code{group.by} variable.
Importantly, before using \code{\link[=combineExpression]{combineExpression()}} ensure the
barcodes of the single-cell object object match the barcodes in the output
of the \code{\link[=combineTCR]{combineTCR()}} or \code{\link[=combineBCR]{combineBCR()}}.
}
\examples{
# Getting the combined contigs
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Getting a sample of a Seurat object
scRep_example <- get(data("scRep_example"))

# Using combineExpresion()
scRep_example <- combineExpression(combined, scRep_example)

}
\concept{SC_Functions}
