% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addVariable.R
\name{addVariable}
\alias{addVariable}
\title{Adding Variables After combineTCR() or combineBCR()}
\usage{
addVariable(input.data, variable.name = NULL, variables = NULL)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}} or \code{\link[=combineBCR]{combineBCR()}}.}

\item{variable.name}{A character string that defines the new variable to add.}

\item{variables}{A character vector defining the desired column value for
each list element. Must match the length of the product of \code{\link[=combineTCR]{combineTCR()}} or
\code{\link[=combineBCR]{combineBCR()}}.}
}
\value{
input.data list with the variable column added to each element.
}
\description{
This function adds variables to the product of \code{\link[=combineTCR]{combineTCR()}},
or \code{\link[=combineBCR]{combineBCR()}} to be used in later visualizations.
For each element, the function will add a column (labeled by
\code{variable.name}) with the variable. The length of the
\code{variables} parameter needs to match the length of the
combined object.
}
\examples{
combined <- combineTCR(contig_list, 
                       samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))
combined <- addVariable(combined, 
                        variable.name = "Type", 
                        variables = rep(c("B", "L"), 4))

}
\concept{Loading_and_Processing_Contigs}
