% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alluvialClones.R
\name{alluvialClones}
\alias{alluvialClones}
\title{Alluvial Plotting for Single-Cell Object}
\usage{
alluvialClones(
  sc.data,
  cloneCall = "strict",
  chain = "both",
  y.axes = NULL,
  color = NULL,
  alpha = NULL,
  facet = NULL,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{sc.data}{The product of \code{\link[=combineExpression]{combineExpression()}}.}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL},
\code{IGK}, \code{Light} (for both light chains), or \code{both} (for TRA/B and Heavy/Light).}

\item{y.axes}{The columns that will separate the proportional .
visualizations.}

\item{color}{The column header or clone(s) to be highlighted.}

\item{alpha}{The column header to have gradated opacity.}

\item{facet}{The column label to separate.}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}.}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object visualizing categorical distribution of clones, or a
data.frame if \code{exportTable = TRUE}.
}
\description{
View the proportional contribution of clones by Seurat or SCE object
meta data after \code{\link[=combineExpression]{combineExpression()}}. The visualization
is based on the ggalluvial package, which requires the aesthetics
to be part of the axes that are visualized. Therefore, alpha, facet,
and color should be part of the the axes you wish to view or will
add an additional stratum/column to the end of the graph.
}
\examples{
# Getting the combined contigs
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))

# Getting a sample of a Seurat object
scRep_example <- get(data("scRep_example"))

# Using combineExpresion()
scRep_example <- combineExpression(combined, scRep_example)
scRep_example$Patient <- substring(scRep_example$orig.ident, 1,3)

# Using alluvialClones()
alluvialClones(scRep_example, 
                   cloneCall = "gene", 
                   y.axes = c("Patient", "ident"), 
                   color = "ident")

}
\concept{SC_Functions}
