% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonalHomeostasis.R
\name{clonalHomeostasis}
\alias{clonalHomeostasis}
\title{Plot Clonal Homeostasis of the Repertoire}
\usage{
clonalHomeostasis(
  input.data,
  cloneSize = c(Rare = 1e-04, Small = 0.001, Medium = 0.01, Large = 0.1, Hyperexpanded =
    1),
  cloneCall = "strict",
  chain = "both",
  group.by = NULL,
  order.by = NULL,
  exportTable = FALSE,
  palette = "inferno",
  ...
)
}
\arguments{
\item{input.data}{The product of \code{\link[=combineTCR]{combineTCR()}}, \code{\link[=combineBCR]{combineBCR()}}, or
\code{\link[=combineExpression]{combineExpression()}}.}

\item{cloneSize}{The cut points of the proportions.}

\item{cloneCall}{Defines the clonal sequence grouping. Accepted values
are: \code{gene} (VDJC genes), \code{nt} (CDR3 nucleotide sequence), \code{aa} (CDR3 amino
acid sequence), or \code{strict} (VDJC + nt). A custom column header can also be used.}

\item{chain}{The TCR/BCR chain to use. Use \code{both} to include both chains
(e.g., TRA/TRB). Accepted values: \code{TRA}, \code{TRB}, \code{TRG}, \code{TRD}, \code{IGH}, \code{IGL},
\code{IGK}, \code{Light} (for both light chains), or \code{both} (for TRA/B and Heavy/Light).}

\item{group.by}{A column header in the metadata or lists to group the analysis
by (e.g., "sample", "treatment"). If \code{NULL}, data will be analyzed
by list element or active identity in the case of single-cell objects.}

\item{order.by}{A character vector defining the desired order of elements
of the \code{group.by} variable. Alternatively, use \code{alphanumeric} to sort groups
automatically.}

\item{exportTable}{If \code{TRUE}, returns a data frame or matrix of the results
instead of a plot.}

\item{palette}{Colors to use in visualization - input any
\link[grDevices:palettes]{hcl.pals}.}

\item{...}{Additional arguments passed to the ggplot theme}
}
\value{
A ggplot object visualizing clonal homeostasis, or a data.frame if
\code{exportTable = TRUE}.
}
\description{
This function calculates the space occupied by clone proportions.
The grouping of these clones is based on the parameter \code{cloneSize},
at default, \code{cloneSize} will group the clones into bins of Rare = 0
to 0.0001, Small = 0.0001 to 0.001, etc. To adjust the proportions,
change the number or labeling of the cloneSize parameter. If a matrix
output for the data is preferred, set \code{exportTable} = TRUE.
}
\examples{
# Making combined contig data
combined <- combineTCR(contig_list, 
                        samples = c("P17B", "P17L", "P18B", "P18L", 
                                    "P19B","P19L", "P20B", "P20L"))
clonalHomeostasis(combined, cloneCall = "gene")

}
\concept{Visualizing_Clones}
