% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_param.R
\name{model_param}
\alias{model_param}
\title{model_param}
\usage{
model_param(fit.model, gof.res, model = NULL)
}
\arguments{
\item{fit.model}{A list of models fitted by 'glm' from \code{fit_models}.}

\item{gof.res}{A list of selected model distributions for genes \code{select_model}.}

\item{model}{A specific model to fit (1:P, 2:NB, 3:ZIP, 4:ZINB, NULL:All)}
}
\value{
A list of model parameters estimated. Estimated model parameters include
mean (for all 4 models), theta (over-dispersion parameter for NB & ZINB models), pi (zero-inflation parameter
for ZIP & ZINB models).
}
\description{
This function returns model parameters based on the best fit distribution
as selected by \code{distr_fit} and models fitted by \code{fit_models}
}
\examples{

data(scData)

# apply the model_param function to extract the parameters of the best fit
# model obtained by running the select_model function

library(BiocParallel)
scData_models <- fit_models(counts=scData$counts, cexpr=scData$covariates, lib.size=scData$lib_size,
BPPARAM=bpparam())
scData_bicvals <- model_bic(scData_models)
scData_least.bic <- lbic_model(scData_bicvals, scData$counts)
scData_gof <- gof_model(scData_least.bic, cexpr=scData$covariates, lib.size=scData$lib_size,
BPPARAM=bpparam())
scData_fit <- select_model(scData_gof)

scData_params <- model_param(scData_models, scData_fit, model=NULL)
}
