% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{createFromSeurat}
\alias{createFromSeurat}
\title{Creates a `TreeViz` object from `Seurat`}
\usage{
createFromSeurat(
  object,
  check_metadata = FALSE,
  col_regex = "*snn*",
  columns = NULL,
  reduced_dim = c("TSNE")
)
}
\arguments{
\item{object}{`Seurat` class containing cluster information at different resolutions}

\item{check_metadata}{whether to metaData of `Seurat` object for cluster information or not}

\item{col_regex}{common regular expression shared across all columns with cluster information}

\item{columns}{vector containing columns with cluster information}

\item{reduced_dim}{Vector of Dimensionality reduction information provided in `Seurat` object to be added in `TreeViz` (if exists)}
}
\value{
`TreeViz` Object
}
\description{
Creates a `TreeViz` object from `Seurat`
}
\examples{
library(Seurat)
data(pbmc_small)
pbmc <- pbmc_small
treeviz<- createFromSeurat(pbmc, check_metadata = TRUE, reduced_dim = c("pca","tsne"))
}
