% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_metrics.R
\name{reportMissingValues}
\alias{reportMissingValues}
\title{Four metrics to report missing values}
\usage{
reportMissingValues(object, i, by = NULL)
}
\arguments{
\item{object}{An object of class \link{QFeatures}.}

\item{i}{The index of the assay in \code{object}. The assay must
contain an identification matrix, that is a matrix where an
entry is \code{TRUE} if the value is observed and \code{FALSE} is the
value is missing (see examples). \code{i} may be numeric, character
or logical, but it must select only one assay.}

\item{by}{A vector of length equal to the number of columns in
assay \code{i} that defines groups for which the metrics should be
computed separately. If missing, the metrics are computed for
the complete assay.}
}
\value{
A \code{data.frame} with groups as rows and 5 columns:
\itemize{
\item \code{LocalSensitivityMean}: the average number of features per cell.
\item \code{LocalSensitivitySd}: the standard deviation of the local
sensitivity.
\item \code{TotalSensitivity}: the total number of features found in the
dataset.
\item \code{Completeness}: the proportion of values that are not missing in
the data.
\item \code{NumberCells}: the number of cells in the dataset.
}
}
\description{
The function computes four metrics to report missing values in
single-cell proteomics.
}
\examples{

data("scp1")

## Define the identification matrix
peps <- scp1[["peptides"]]
assay(peps) <- !is.na(assay(peps))
scp1 <- addAssay(scp1, peps, "id")

## Report metrics 
reportMissingValues(scp1, "id")
## Report metrics by sample type
reportMissingValues(scp1, "id", scp1$SampleType)

data

}
