% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScpModel-Utils.R
\name{scpAnnotateResults}
\alias{scpAnnotateResults}
\title{Annotate single-cell proteomics analysis output}
\usage{
scpAnnotateResults(tableList, annotations, by, by2 = NULL)
}
\arguments{
\item{tableList}{A list of tables, typically the output of
\code{scpVarianceAnalysis()}, \code{scpDifferentialAnalysis()}, or the
the \code{bySample} or \code{byFeature} elements returned by
\code{scpComponentAnalysis()}.}

\item{annotations}{A table of class 'data.frame' or 'DFrame'
containing the annotations to add. If no further arguments are
provided, the table must have row names.}

\item{by}{A \code{character(1)} providing the name of the column in the
tables in \code{tableList} to use to match the rows of the
annotation table.}

\item{by2}{A \code{character(1)} providing the name of the column in the
annotation table to use to match the rows of the tables in
\code{tableList}. If \code{NULL}, it will be defined by \code{by}. The column
pointed by \code{by2} will be dropped in the output tables.}
}
\description{
The function takes as input a list of \code{DFrame} and a table with
additional annotations. The annotation tables is automatically
merged into all tables of the list by matching the specified
columns (given by the arguments \code{by} and \code{by2}). This function is
useful to add annotation to analysis results generated by
\code{scpVarianceAnalysis()}, \code{scpDifferentialAnalysis()}, or
\code{scpComponentAnalysis()}. The annotation table is typically the
\code{colData} or \code{rowData} of the object used for modelling. In case
of shared column names between the input tables and the annotation
table, any annotation that is already present in the list of
tables will be overwritten by the new annotations.
}
\examples{
data("leduc_minimal")
var <- scpVarianceAnalysis(leduc_minimal)
colnames(var$Residuals)
## Add peptide annotations available from the rowData
var <- scpAnnotateResults(
    var, rowData(leduc_minimal), by = "feature", by2 = "Sequence"
)
colnames(var$Residuals)
}
\seealso{
\itemize{
\item \link{ScpModel-VarianceAnalysis}
\item \link{ScpModel-DifferentialAnalysis}
\item \link{ScpModel-ComponentAnalysis}
}
}
\author{
Christophe Vanderaa, Laurent Gatto
}
