% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineFactors.R
\name{combineFactors}
\alias{combineFactors}
\title{Combine multiple factors}
\usage{
combineFactors(factors, keep.unused = FALSE)
}
\arguments{
\item{factors}{List of vectors or factors of the same length.
Corresponding elements across all vectors/factors represent the combination of levels for a single observation.
For factors, any existing levels are respected.
For other vectors, the sorted and unique values are used as levels.

Alternatively, a data frame where each column is a vector or factor and each row corresponds to an observation.}

\item{keep.unused}{Logical scalar indicating whether to report unused combinations of levels.}
}
\value{
List containing \code{levels}, a data frame containing the sorted and unique combinations of levels from \code{factors};
and \code{index}, an integer vector specifying the index into \code{levels} for each observation.
In other words, for observation \code{i} and factor \code{j}, \code{levels[[[j]][index[i]]} will recover \code{factors[[j]][i]}.
}
\description{
Combine multiple factors into a single factor where each level of the latter is a unique combination of levels from the former.
}
\examples{
combineFactors(list(
    sample(LETTERS[1:5], 100, replace=TRUE),
    sample(3, 100, replace=TRUE)
))

combineFactors(list(
    factor(sample(LETTERS[1:5], 10, replace=TRUE), LETTERS[1:5]),
    factor(sample(5, 10, replace=TRUE), 1:5)
), keep.unused=TRUE)

}
\seealso{
The \code{combine_to_factor} function in \url{https://ltla.github.io/factorize/}.
}
\author{
Aaron Lun
}
