% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-uploader.R
\name{cli_list_projects}
\alias{cli_list_projects}
\title{List projects using Seven Bridges command line uploader}
\usage{
cli_list_projects(token = NULL, uploader = NULL, proxy = NULL)
}
\arguments{
\item{token}{Authentication token.}

\item{uploader}{The directory where Seven Bridges command line uploader
is located (the directory that contains the \code{bin/} directory).}

\item{proxy}{A proxy server through which the uploader should connect.
For details the proxy parameter format, see the part on parameter
\code{--proxy} in the reference below.}
}
\value{
Character vector of the available project names.
}
\description{
List projects available as upload targets using Seven Bridges
command line uploader.
}
\examples{
token <- "your_token"
\dontrun{
cli_list_projects(
  token = token,
  uploader = "~/Downloads/sbg-uploader/"
)}
}
\references{
\url{https://docs.sevenbridges.com/docs/upload-via-the-command-line}
}
\seealso{
See \code{\link{cli_upload}} for uploading files with
the command line uploader, \code{\link{cli_list_tags}} for listing
all tags in a project.
}
