% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAutoco.R
\name{plotAutoco}
\alias{plotAutoco}
\title{Auto-correlation}
\usage{
plotAutoco(plotMatrix, plateRows, plateCols, plotRows = NULL,
  plotCols = NULL, plotName = NULL, plotSep = TRUE, ...)
}
\arguments{
\item{plotMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{plateRows, plateCols}{Number of rows/columns in plate.}

\item{plotRows, plotCols}{Optional integer vector. Indicate which row/column numbers from the plotMatrix should be plotted. If NULL then all rows/columns from the plotMatrix are used.}

\item{plotName}{Optional. Name of plotMatrix for plot title.}

\item{plotSep}{Optional logical. Should plots be presented in separate windows? Default is TRUE.}

\item{...}{Optional. Additional parameters passed to \code{\link[ggplot2]{geom_path}}.}
}
\value{
Modifiable ggplot2 object or list of objects
}
\description{
Plot auto-correlation for each plate
}
\details{
Auto-correlation plots can be used to identify spatial bias.  Non-zero auto-correlations indicate within-plate bias, namely that proximal wells within-plates are correlated and that the measured intensity of a feature depends partially on its well location in the plate.  Cyclical patterns of auto-correlation, in particular indicate within-plate spatial bias.  Normalization methods that produce auto-correlations close to zero indicate the removal of spatial bias.
}
\examples{
## load dataset
data(ex_dataMatrix)

## plot raw data
plotAutoco(plotMatrix = ex_dataMatrix, plateRows = 8, plateCols = 10,
plotCols = 5:10, plotName = 'Example')
## normalize data matrix using any method and store in new variable
ex_normMatrix <- normZ(dataMatrix = ex_dataMatrix, dataCols = 5:10)
## plot normalized data
plotAutoco(plotMatrix = ex_normMatrix, plotName = 'Example',
plateRows = 8, plateCols = 10, plotSep = FALSE)

}
\seealso{
Other graphical devices: \code{\link{plot3d}},
  \code{\link{plotBox}}, \code{\link{plotHeatmap}},
  \code{\link{plotHist}}, \code{\link{plotIGFit}},
  \code{\link{plotScatter}}
}

