% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/feaResult-methods.R
\docType{methods}
\name{drugs}
\alias{drugs}
\alias{drugs<-}
\alias{drugs,feaResult-method}
\alias{drugs<-,feaResult-method}
\alias{drugs,feaResult,ANY-method}
\title{Extract/Assign Drug Names for feaResult}
\usage{
drugs(x)

drugs(x) <- value

\S4method{drugs}{feaResult}(x)

\S4method{drugs}{feaResult}(x) <- value
}
\arguments{
\item{x}{feaResult object}

\item{value}{A character vector of drug names}
}
\value{
character vector

An feaResult object with new assigned drugs slot
}
\description{
The \code{drugs} generic extracts or assign the drug names/ids 
stored in the \code{drugs} slot of an feaResult object.
}
\examples{
fr <- feaResult(result=dplyr::tibble(id=letters[seq_len(10)], 
                                     val=seq_len(10)),
                organism="human", ontology="MF", drugs=c("d1", "d2"), 
                targets=c("t1","t2"))
drugs(fr)
drugs(fr) <- c("d3", "d4")
}
