% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mabsAnalyser.R
\name{mabsGO}
\alias{mabsGO}
\title{MeanAbs Enrichment Analysis for GO}
\usage{
mabsGO(
  geneList,
  ont = "BP",
  OrgDb,
  keyType = "SYMBOL",
  nPerm = 1000,
  minGSSize = 5,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH"
)
}
\arguments{
\item{geneList}{named numeric vector with gene SYMBOLs in the name slot 
decreasingly ranked by scores in the data slot.}

\item{ont}{one of "BP", "MF", "CC" or "ALL"}

\item{OrgDb}{OrgDb}

\item{keyType}{keytype of gene}

\item{nPerm}{permutation numbers}

\item{minGSSize}{integer, minimum size of each gene set in annotation system}

\item{maxGSSize}{integer, maximum size of each gene set in annotation system}

\item{pvalueCutoff}{pvalue cutoff}

\item{pAdjustMethod}{pvalue adjustment method}
}
\value{
\code{\link{feaResult}} object
}
\description{
MeanAbs enrichment analysis with GO terms.
}
\examples{
data(targetList)
#mg <- mabsGO(geneList=targetList, ont="MF", OrgDb="org.Hs.eg.db",
#             pvalueCutoff=1)
#head(mg)
}
\author{
Yuzhu Duan
}
