% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundance.R
\name{getDiffAbundanceResults}
\alias{getDiffAbundanceResults}
\alias{getDiffAbundanceResults,SingleCellExperiment-method}
\alias{getDiffAbundanceResults<-}
\alias{getDiffAbundanceResults<-,SingleCellExperiment-method}
\title{Get/Set diffAbundanceFET result table}
\usage{
getDiffAbundanceResults(x, analysisName)

\S4method{getDiffAbundanceResults}{SingleCellExperiment}(x, analysisName)

getDiffAbundanceResults(x, analysisName) <- value

\S4method{getDiffAbundanceResults}{SingleCellExperiment}(x, analysisName) <- value
}
\arguments{
\item{x}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}}
object.}

\item{analysisName}{A single character string specifying an analysis 
performed with \code{\link{diffAbundanceFET}}}

\item{value}{The output table of \code{\link{diffAbundanceFET}}}
}
\value{
The differential abundance table for getter method, or update the SCE
object with new result for setter method.
}
\description{
Get/Set diffAbundanceFET result table
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- diffAbundanceFET(inSCE = mouseBrainSubsetSCE,
                                                cluster = "tissue",
                                                variable = "level1class",
                                                case = "oligodendrocytes",
                                                control = "microglia",
                                                analysisName = "diffAbund")
result <- getDiffAbundanceResults(mouseBrainSubsetSCE, "diffAbund")
}
