% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDEAnalysis.R
\name{plotDEGHeatmap}
\alias{plotDEGHeatmap}
\title{Heatmap visualization of DEG result}
\usage{
plotDEGHeatmap(
  inSCE,
  useResult,
  onlyPos = FALSE,
  log2fcThreshold = 0.25,
  fdrThreshold = 0.05,
  minGroup1MeanExp = NULL,
  maxGroup2MeanExp = NULL,
  minGroup1ExprPerc = NULL,
  maxGroup2ExprPerc = NULL,
  useAssay = NULL,
  doLog = FALSE,
  featureAnnotations = NULL,
  cellAnnotations = NULL,
  featureAnnotationColor = NULL,
  cellAnnotationColor = NULL,
  rowDataName = NULL,
  colDataName = NULL,
  colSplitBy = "condition",
  rowSplitBy = "regulation",
  rowLabel = S4Vectors::metadata(inSCE)$featureDisplay,
  title = paste0("DE Analysis: ", useResult),
  ...
)
}
\arguments{
\item{inSCE}{\linkS4class{SingleCellExperiment} inherited object.}

\item{useResult}{character. A string specifying the \code{analysisName}
used when running a differential expression analysis function.}

\item{onlyPos}{logical. Whether to only plot DEG with positive log2_FC
value. Default \code{FALSE}.}

\item{log2fcThreshold}{numeric. Only plot DEGs with the absolute values of
log2FC larger than this value. Default \code{0.25}.}

\item{fdrThreshold}{numeric. Only plot DEGs with FDR value smaller than this
value. Default \code{0.05}.}

\item{minGroup1MeanExp}{numeric. Only plot DEGs with mean expression in
group1 greater then this value. Default \code{NULL}.}

\item{maxGroup2MeanExp}{numeric. Only plot DEGs with mean expression in
group2 less then this value. Default \code{NULL}.}

\item{minGroup1ExprPerc}{numeric. Only plot DEGs expressed in greater then
this fraction of cells in group1. Default \code{NULL}.}

\item{maxGroup2ExprPerc}{numeric. Only plot DEGs expressed in less then this
fraction of cells in group2. Default \code{NULL}.}

\item{useAssay}{character. A string specifying an assay of expression value
to plot. By default the assay used for \code{runMAST()} will be used.
Default \code{NULL}.}

\item{doLog}{Logical scalar. Whether to do \code{log(assay + 1)}
transformation on the assay used for the analysis. Default \code{FALSE}.}

\item{featureAnnotations}{\code{data.frame}, with \code{rownames} containing
all the features going to be plotted. Character columns should be factors.
Default \code{NULL}.}

\item{cellAnnotations}{\code{data.frame}, with \code{rownames} containing
all the cells going to be plotted. Character columns should be factors.
Default \code{NULL}.}

\item{featureAnnotationColor}{A named list. Customized color settings for
feature labeling. Should match the entries in the \code{featureAnnotations}
or \code{rowDataName}. For each entry, there should be a list/vector of
colors named with categories. Default \code{NULL}.}

\item{cellAnnotationColor}{A named list. Customized color settings for
cell labeling. Should match the entries in the \code{cellAnnotations} or
\code{colDataName}. For each entry, there should be a list/vector of colors
named with categories. Default \code{NULL}.}

\item{rowDataName}{character. The column name(s) in \code{rowData} that need
to be added to the annotation. Default \code{NULL}.}

\item{colDataName}{character. The column name(s) in \code{colData} that need
to be added to the annotation. Default \code{NULL}.}

\item{colSplitBy}{character. Do semi-heatmap based on the grouping of
this(these) annotation(s). Should exist in either \code{colDataName} or
\code{names(cellAnnotations)}. Default \code{"condition"}.}

\item{rowSplitBy}{character. Do semi-heatmap based on the grouping of
this(these) annotation(s). Should exist in either \code{rowDataName} or
\code{names(featureAnnotations)}. Default \code{"regulation"}.}

\item{rowLabel}{\code{FALSE} for not displaying; a variable in \code{rowData}
to display feature identifiers stored there; if have run
\code{\link{setSCTKDisplayRow}}, display the specified feature name;
\code{TRUE} for the \code{rownames} of \code{inSCE}; \code{NULL} for
auto-display \code{rownames} when the number of filtered feature is less
than 60. Default looks for \code{\link{setSCTKDisplayRow}} information.}

\item{title}{character. Main title of the heatmap. Default
\code{"DE Analysis: <useResult>"}.}

\item{...}{Other arguments passed to \code{\link{plotSCEHeatmap}}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Heatmap visualization of DEG result
}
\details{
A differential expression analysis function has to be run in advance
so that information is stored in the metadata of the input SCE object. This
function wraps \code{\link{plotSCEHeatmap}}.
A feature annotation basing on the log2FC level called \code{"regulation"}
will be automatically added. A cell annotation basing on the condition
selection while running the analysis called \code{"condition"}, and the
annotations used from \code{colData(inSCE)} while setting the condition and
covariates will also be added.
}
\examples{
data("sceBatches")
logcounts(sceBatches) <- log1p(counts(sceBatches))
sce.w <- subsetSCECols(sceBatches, colData = "batch == 'w'")
sce.w <- runWilcox(sce.w, class = "cell_type",
                   classGroup1 = "alpha", classGroup2 = "beta",
                   groupName1 = "w.alpha", groupName2 = "w.beta",
                   analysisName = "w.aVSb")
plotDEGHeatmap(sce.w, "w.aVSb")
}
\author{
Yichen Wang
}
