% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{plotSeuratJackStraw}
\alias{plotSeuratJackStraw}
\title{plotSeuratJackStraw
Computes the plot object for jackstraw plot from the pca slot in the input
sce object}
\usage{
plotSeuratJackStraw(
  inSCE,
  dims = NULL,
  xmax = 0.1,
  ymax = 0.3,
  externalReduction = NULL
)
}
\arguments{
\item{inSCE}{(sce) object from which to compute the jackstraw plot (pca
should be computed)}

\item{dims}{Number of components to plot in Jackstraw. If \code{NULL}, then
all components are plotted Default \code{NULL}.}

\item{xmax}{X-axis maximum on each QQ plot. Default \code{0.1}.}

\item{ymax}{Y-axis maximum on each QQ plot. Default \code{0.3}.}

\item{externalReduction}{Pass DimReduc object if PCA/ICA computed through
other libraries. Default \code{NULL}.}
}
\value{
plot object
}
\description{
plotSeuratJackStraw
Computes the plot object for jackstraw plot from the pca slot in the input
sce object
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runSeuratNormalizeData(sce, useAssay = "counts")
sce <- runSeuratFindHVG(sce, useAssay = "counts")
sce <- runSeuratScaleData(sce, useAssay = "counts")
sce <- runSeuratPCA(sce, useAssay = "counts")
sce <- runSeuratJackStraw(sce, useAssay = "counts")
plotSeuratJackStraw(sce)
}
}
