% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBatchCorrection.R
\name{runSCANORAMA}
\alias{runSCANORAMA}
\title{Apply the mutual nearest neighbors (MNN) batch effect correction method to
SingleCellExperiment object}
\usage{
runSCANORAMA(
  inSCE,
  useAssay = "logcounts",
  batch = "batch",
  assayName = "SCANORAMA",
  SIGMA = 15,
  ALPHA = 0.1,
  KNN = 20,
  approx = TRUE
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object}

\item{useAssay}{A single character indicating the name of the assay requiring
batch correction. Scanorama requires a transformed normalized expression
assay. Default \code{"logcounts"}.}

\item{batch}{A single character indicating a field in \code{colData} that
annotates the batches of each cell; or a vector/factor with the same length
as the number of cells. Default \code{"batch"}.}

\item{assayName}{A single characeter. The name for the corrected assay. Will
be saved to \code{\link{assay}}. Default
\code{"SCANORAMA"}.}

\item{SIGMA}{A numeric scalar. Algorithmic parameter, correction smoothing
parameter on Gaussian kernel. Default \code{15}.}

\item{ALPHA}{A numeric scalar. Algorithmic parameter, alignment score
minimum cutoff. Default \code{0.1}.}

\item{KNN}{An integer. Algorithmic parameter, number of nearest neighbors to
use for matching. Default \code{20}.}

\item{approx}{Boolean. Use approximate nearest neighbors, greatly speeds up
matching runtime. Default \code{TRUE}.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{assay(inSCE, assayName)} updated.
}
\description{
SCANORAMA is analogous to computer vision algorithms for panorama stitching
that identify images with overlapping content and merge these into a larger
panorama.
}
\examples{
\dontrun{
data('sceBatches', package = 'singleCellTK')
logcounts(sceBatches) <- log1p(counts(sceBatches))
sceCorr <- runSCANORAMA(sceBatches, "ScaterLogNormCounts")
}
}
\references{
Brian Hie et al, 2019
}
