% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{runSeuratHeatmap}
\alias{runSeuratHeatmap}
\title{runSeuratHeatmap
Computes the heatmap plot object from the pca slot in the input sce object}
\usage{
runSeuratHeatmap(
  inSCE,
  useAssay,
  useReduction = c("pca", "ica"),
  dims = NULL,
  nfeatures = 30,
  cells = NULL,
  ncol = NULL,
  balanced = TRUE,
  fast = TRUE,
  combine = TRUE,
  raster = TRUE,
  externalReduction = NULL
)
}
\arguments{
\item{inSCE}{(sce) object from which to compute heatmap (pca should be
computed)}

\item{useAssay}{Specify name of the assay that will be scaled
by this function. The output scaled assay will be used for computation
of the heatmap.}

\item{useReduction}{Reduction method to use for computing clusters. One of
"pca" or "ica". Default \code{"pca"}.}

\item{dims}{Number of components to generate heatmap plot objects. If
\code{NULL}, a heatmap will be generated for all components. Default
\code{NULL}.}

\item{nfeatures}{Number of features to include in the heatmap. Default
\code{30}.}

\item{cells}{Numeric value indicating the number of top cells to plot.
Default is \code{NULL} which indicates all cells.}

\item{ncol}{Numeric value indicating the number of columns to use for plot.
Default is \code{NULL} which will automatically compute accordingly.}

\item{balanced}{Plot equal number of genes with positive and negative scores.
Default is \code{TRUE}.}

\item{fast}{See \link[Seurat]{DimHeatmap} for more information. Default
\code{TRUE}.}

\item{combine}{See \link[Seurat]{DimHeatmap} for more information. Default
\code{TRUE}.}

\item{raster}{See \link[Seurat]{DimHeatmap} for more information. Default
\code{TRUE}.}

\item{externalReduction}{Pass DimReduc object if PCA/ICA computed through
other libraries. Default \code{NULL}.}
}
\value{
plot object
}
\description{
runSeuratHeatmap
Computes the heatmap plot object from the pca slot in the input sce object
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runSeuratNormalizeData(sce, useAssay = "counts")
sce <- runSeuratFindHVG(sce, useAssay = "counts")
sce <- runSeuratScaleData(sce, useAssay = "counts")
sce <- runSeuratPCA(sce, useAssay = "counts")
heatmap <- runSeuratHeatmap(sce, useAssay = "counts")
plotSeuratHeatmap(heatmap)
}
}
