% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{runSeuratScaleData}
\alias{runSeuratScaleData}
\title{runSeuratScaleData
Scales the input sce object according to the input parameters}
\usage{
runSeuratScaleData(
  inSCE,
  useAssay = "seuratNormData",
  scaledAssayName = "seuratScaledData",
  model = "linear",
  scale = TRUE,
  center = TRUE,
  scaleMax = 10,
  verbose = TRUE
)
}
\arguments{
\item{inSCE}{(sce) object to scale}

\item{useAssay}{Assay containing normalized counts to scale.}

\item{scaledAssayName}{Name of new assay containing scaled data. Default
\code{seuratScaledData}.}

\item{model}{selected model to use for scaling data. Default \code{"linear"}.}

\item{scale}{boolean if data should be scaled or not. Default \code{TRUE}.}

\item{center}{boolean if data should be centered or not. Default \code{TRUE}}

\item{scaleMax}{maximum numeric value to return for scaled data. Default
\code{10}.}

\item{verbose}{Logical value indicating if informative messages should
be displayed. Default is \code{TRUE}.}
}
\value{
Scaled \code{SingleCellExperiment} object
}
\description{
runSeuratScaleData
Scales the input sce object according to the input parameters
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runSeuratNormalizeData(sce, useAssay = "counts")
sce <- runSeuratFindHVG(sce, useAssay = "counts")
sce <- runSeuratScaleData(sce, useAssay = "counts")
}
}
