% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTSCAN.R
\name{runTSCANDEG}
\alias{runTSCANDEG}
\title{Test gene expression changes along a TSCAN trajectory path}
\usage{
runTSCANDEG(inSCE, pathIndex, useAssay = "logcounts", discardCluster = NULL)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{pathIndex}{Path index for which the pseudotime values should be used.
This corresponds to the terminal node of specific path from the root
node to the terminal node. Run \code{listTSCANTerminalNodes(inSCE)} for
available options.}

\item{useAssay}{Character. The name of the assay to use for testing the
expression change. Should be log-normalized. Default \code{"logcounts"}}

\item{discardCluster}{Cluster(s) which are not of use or masks other
interesting effects can be discarded. Default \code{NULL}.}
}
\value{
The input \code{inSCE} with results updated in \code{metadata}.
}
\description{
Wrapper for identifying genes with significant changes with
respect to one of the TSCAN pseudotime paths
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runTSCAN(inSCE = mouseBrainSubsetSCE,
                                useReducedDim = "PCA_logcounts")
terminalNodes <- listTSCANTerminalNodes(mouseBrainSubsetSCE)
mouseBrainSubsetSCE <- runTSCANDEG(inSCE = mouseBrainSubsetSCE,
                                   pathIndex = terminalNodes[1])
}
\author{
Nida Pervaiz
}
