% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siteNumbering.R
\name{setSiteNumbering}
\alias{setSiteNumbering}
\alias{setSiteNumbering.phyMSAmatched}
\title{Set site numbering to the reference sequence}
\usage{
setSiteNumbering(x, reference, gapChar, ...)

\method{setSiteNumbering}{phyMSAmatched}(x, reference = NULL, gapChar = "-", minSkipSize = NULL, ...)
}
\arguments{
\item{x}{The object to set site numbering. It could be a
\code{\link{phyMSAmatched}} or a \code{\link{lineagePath}} object.}

\item{reference}{Name of reference for site numbering. The name has to be one
of the sequences' name. The default uses the intrinsic alignment numbering}

\item{gapChar}{The character to indicate gap. The numbering will skip the
\code{gapChar} for the reference sequence.}

\item{...}{Further arguments passed to or from other methods.}

\item{minSkipSize}{The minimum number of tips to have gap or ambiguous amino
acid/nucleotide for a site to be ignored in other analysis. This will not
affect the numbering. The default is 0.8.}
}
\value{
The input \code{x} with numbering mapped to \code{reference}.
}
\description{
A reference sequence can be used to define a global site
  numbering scheme for multiple sequence alignment. The gap in the reference
  sequence will be skipped for the numbering. Also, the site that is gap or
  amino acid/nucleotide for too many tips will be ignored but won't affect
  numbering.
}
\examples{
data(zikv_tree)
msaPath <- system.file('extdata', 'ZIKV.fasta', package = 'sitePath')
tree <- addMSA(zikv_tree, msaPath = msaPath, msaFormat = 'fasta')
setSiteNumbering(tree)
}
