% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf_iae_wrappers.R
\name{idf_prob}
\alias{idf_prob}
\title{labeled inverse cell frequency: probability based}
\usage{
idf_prob(expr, features = NULL, label, multi = TRUE, thres = 0)
}
\arguments{
\item{expr}{a matrix, features in row and cells in column}

\item{features}{vector, feature names or indexes to compute}

\item{label}{vector, group label of each cell}

\item{multi}{logical, if to compute based on binary (FALSE) or multi-class (TRUE)}

\item{thres}{numeric, cell only counts when expr > threshold, default 0}
}
\value{
a matrix of inverse cell frequency score
}
\description{
labeled inverse cell frequency: probability based
}
\details{
\deqn{\mathbf{IDF_{i,j}} = log(1+\frac{\frac{n_{i,j\in D}}{n_{j\in D}}}{max(\frac{n_{i,j\in \hat D}}{n_{j\in \hat D}})+ e^{-8}}\frac{n_{i,j\in D}}{n_{j\in D}})}
where \eqn{n_{i,j\in D}} is the number of cells containing feature \eqn{i} in
class \eqn{D}, \eqn{n_{j\in D}} is the total number of cells in class \eqn{D},
\eqn{\hat D} is the class except \eqn{D}.
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
smartid:::idf_prob(data, label = sample(c("A", "B"), 10, replace = TRUE))
}
