% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.df2ppp}
\alias{.df2ppp}
\title{Function to convert \code{data.frame} to \code{ppp} object}
\usage{
.df2ppp(df, xName, yName, marks = NULL)
}
\arguments{
\item{df}{data.frame; with x, y coordinates, image, and categorical mark information.}

\item{xName}{character; column name of x coordinate}

\item{yName}{character; column name of y coordinate}

\item{marks}{character; column name of the mark variable}
}
\value{
ppp; object of type \code{ppp}
}
\description{
Assumes that the \code{data.frame} is the output of \code{.SPE2df()}. Column order is important!
}
\examples{
data(sostaSPE)
df <- .SPE2df(sostaSPE, marks = "cellType", imageCol = "imageName")
ppp <- .df2ppp(df, xName = "x", yName = "y", marks = "cellType")
}
\seealso{
\code{\link{.SPE2df}}, \code{\link[spatstat.geom]{as.ppp}}
}
