% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateIndividualLogFC.R
\name{calculateIndividualLogFC}
\alias{calculateIndividualLogFC}
\title{Utility function to run limma differential expression analysis}
\usage{
calculateIndividualLogFC(
  x,
  design,
  contrast = ncol(design),
  robust.fit = FALSE,
  robust.eBayes = FALSE,
  trend.eBayes = FALSE,
  treat.lfc = NULL,
  weights = NULL,
  confint = TRUE,
  with.fit = FALSE,
  use.qlf = TRUE,
  ...,
  xmeta. = NULL,
  as.dt = FALSE
)
}
\arguments{
\item{x}{The expression object. This can be 1 column matrix if you are not
running any analysis, and this function essentially is just a
"pass through"}

\item{design}{The design matrix for the experiment}

\item{contrast}{The contrast you want to test and provide stats for. By
default this tests the last column of the \code{design} matrix. If you
want to test a custom contrast, this can be a contrast vector, which
means that it should be as long as \code{ncol(design)} and it most-often sum to
one. In the future, the user will be able to specify a range of
coefficients over \code{design} to perform an ANOVA analysis, cf.
Issue #11 (https://github.com/lianos/multiGSEA/issues/11).}

\item{robust.fit}{The value of the \code{robust} parameter to pass down to the
\code{\link[limma:lmFit]{limma::lmFit()}} function. Defaults to \code{FALSE}.}

\item{robust.eBayes}{The value of the \code{robust} parameter to pass down to
the limma::eBayes()] function.}

\item{trend.eBayes}{The value of the \code{trend} parameter to pass down to the
\code{\link[limma:ebayes]{limma::eBayes()}} function.}

\item{treat.lfc}{If this is numeric, this activates limma's "treat"
functionality and tests for differential expression against this
specified log fold change threshold. This defaults to \code{NULL}.}

\item{weights}{an option matrix of weights to use in \code{\link[limma:lmFit]{limma::lmFit()}}.
If \code{x} is an EList already, and \code{x$weights} is already defined, this
argument will be ignored.}

\item{confint}{add confidence intervals to \code{topTable} output (default
\code{TRUE})? Ignored if \code{x} is a \code{DGEList}.}

\item{with.fit}{If \code{TRUE}, this function returns a list object with
both the fit and the table of logFC statistics, otherwise just the
logFC statistics table is returned.}

\item{use.qlf}{If \code{TRUE} (default), will use edgeR's quasilikelihood
framework for analysis, otherwise uses glmFit/glmTest.}

\item{...}{parameters passed down into the relevant limma/edgeR based
functions.}

\item{xmeta.}{a data.frame to add meta data (symbol, primarly) to the outgoing
logFC data.frame. This is used when \code{x} was a vector (pre-ranked).}

\item{as.dt}{If \code{FALSE} (default), the data.frame like thing that
this funciton returns will be set to a data.frame. Set this to \code{TRUE}
to keep this object as a \code{data.table}}
}
\value{
If \code{with.fit == FALSE} (the default) a \code{data.table} of
logFC statistics for the contrast under test. Otherwise, a list is
returned with \verb{$result} containing the logFC statistics, and
\verb{$fit} has the limma fit for the data/design/contrast under test.
}
\description{
Utility function to run limma differential expression analysis
}
\details{
This function fits linear modles (or glms) to perform differential
expression analyses. If the \code{x} object is a \code{DGEList} the
analysis will be performed using edgeR's quasi-likelihood framework,
otherwise limma will be used for all other scenarios.

If \code{x} is a \code{\link[edgeR:DGEList]{edgeR::DGEList()}} we require that \code{\link[edgeR:estimateDisp]{edgeR::estimateDisp()}} has
already been called. If you prefer to analyze rnaseq data using voom, be sure
that \code{x} is the object that has been returned from a call to \code{\link[limma:voom]{limma::voom()}}
(or \code{\link[limma:voomWithQualityWeights]{limma::voomWithQualityWeights()}}.

The documentation here is speaking the language of a "limma" analysis,
however for each parameter, there is an analagous function/parameter that
will be delegated to.

Lastly, if \code{x} is simply a single column matrix, we assume that we are
just passing a single pre-ranked vector of statistics through sparrow::seas's
analysis pipelines (for use in methods like "fgsea", "cameraPR", etc.), and
a logFC-like data.frame is constructed with these statistics in the
\code{logFC} and \code{t} columns.
}
\examples{
vm <- exampleExpressionSet(do.voom = TRUE)
lfc <- calculateIndividualLogFC(vm, vm$design, "tumor")
}
