% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/GeneSetDb-methods.R,
%   R/SparrowResult-methods.R
\name{geneSetCollectionURLfunction}
\alias{geneSetCollectionURLfunction}
\alias{geneSetCollectionURLfunction<-}
\alias{geneSetCollectionURLfunction,GeneSetDb-method}
\alias{geneSetCollectionURLfunction<-,GeneSetDb-method}
\alias{geneSetCollectionURLfunction,SparrowResult-method}
\title{Get/set the gene set collection url function for a geneset collection}
\usage{
geneSetCollectionURLfunction(x, i, ...)

geneSetCollectionURLfunction(x, i) <- value

\S4method{geneSetCollectionURLfunction}{GeneSetDb}(x, i, ...)

\S4method{geneSetCollectionURLfunction}{GeneSetDb}(x, i) <- value

\S4method{geneSetCollectionURLfunction}{SparrowResult}(x, i, ...)
}
\arguments{
\item{x}{The GeneSetDb}

\item{i}{The collection to get the url function from}

\item{...}{pass through arguments (not used)}

\item{value}{the function to set as the geneset url function for the given
collection \code{i}. This can be an actual function object, or the (string)
name of the function to pull out of "the ether"
(\code{"pkgname::functionname"} can work, too). The latter is preferred as
it results in smaller serialized GeneSetDb objects.}
}
\value{
the function that maps collection,name combinations to an
informational URL.
}
\description{
Reference \code{\link[=collectionMetadata]{collectionMetadata()}} for more info.
}
\section{Methods (by class)}{
\itemize{
\item \code{geneSetCollectionURLfunction(GeneSetDb)}: returns the gene set collection
url function from a GeneSetDb

\item \code{geneSetCollectionURLfunction(GeneSetDb) <- value}: sets the gene set collection url
function for a \code{GeneSetDb : Collection} combination.

\item \code{geneSetCollectionURLfunction(SparrowResult)}: return the url function from a
\code{SparrowResult} object.

}}
\examples{
gdb <- exampleGeneSetDb()
geneSetCollectionURLfunction(gdb, "c2", "BIOCARTA_AGPCR_PATHWAY")
}
