% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{encode_gskey}
\alias{encode_gskey}
\alias{split_gskey}
\title{Converts collection,name combination to key for geneset}
\usage{
encode_gskey(x, y, sep = ";;")

split_gskey(x, sep = ";;")
}
\arguments{
\item{x}{a character vector of encoded geneset keys from \code{\link[=encode_gskey]{encode_gskey()}}}

\item{y}{if \code{x} is a data.frame: nothing, otherwise a character vector
of geneset names}

\item{sep}{the separator used in the encoding of geneset names}
}
\value{
a character vector

a data.frame with (collection,name) columns
}
\description{
The "key" form often comes out as rownames to matrices and such, or
particularly for sending genesets down into wrapped methods, like do.camera.

\code{splt_gskey} is the inverse function of \code{encode_gskey()}
}
\examples{
gdf <- exampleGeneSetDF()
gskeys <- encode_gskey(gdf)
gscols <- split_gskey(gskeys)
}
