% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateInputs.R
\name{validateInputs}
\alias{validateInputs}
\title{Validate the input objects to a GSEA call.}
\usage{
validateInputs(
  x,
  design = NULL,
  contrast = NULL,
  methods = NULL,
  xmeta. = NULL,
  require.x.rownames = TRUE,
  ...
)
}
\arguments{
\item{x}{The expression object to use}

\item{design}{A design matrix, if the GSEA method(s) require it}

\item{contrast}{A contrast vector (if the GSEA method(s) require it)}

\item{methods}{A character vector of the GSEA methods that these inputs will
be used for.}

\item{xmeta.}{hack for supportin data.frame inputs.}

\item{require.x.rownames}{Leave this alone, should always be \code{TRUE} but
have it in this package for dev/testing purposes.}

\item{...}{other variables that called methods can check if they want}
}
\value{
A list with "normalized" versions of \verb{$x}, \verb{$design}, and \verb{$contrast}
for downstream use.
}
\description{
Checks to ensure that the values for \code{x}, \code{design}, and \code{contrast} are
appropriate for the GSEA \code{methods} being used. If they are kosher, then
"normalized" versions of these objects are returned in an (aptly) named list,
otheerwise an error is thrown.
}
\details{
This function is strange in that we both want to verify the objects, and
return them in some canonical form, so it is normal for the caller to then
use the values for \code{x}, \code{design}, and \code{contrast} that are returned from this
call, and not the original values for these objects themselves

I know that the validation/checking logic is a bit painful (and repetitive)
here. I will (perhaps) clean that up some day.
}
\examples{
dge.stats <- exampleDgeResult()
ranks <- setNames(dge.stats$t, dge.stats$feature_id)
gdb <- exampleGeneSetDb()
ok <- validateInputs(ranks, gdb, methods = c("cameraPR", "fgsea"))
# need full expressionset & design for romer
null <- failWith(NULL, validateInputs(ranks, gdb, methods = "romer"))
}
