% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_result_for_roc.R
\name{path_result_for_roc}
\alias{path_result_for_roc}
\title{The path_result_for_roc() function}
\usage{
path_result_for_roc(PREC_for_graph, OMEGA_path, pathnumber)
}
\arguments{
\item{PREC_for_graph}{It is the known precision matrix which is used to
assess the estimated precision matrix from GGM.}

\item{OMEGA_path}{It is a matrix comprising of a series estimated precision 
matrices from a GGM model using a penalized path based on a range of structure
parameters (i.e. \eqn{\lambda,\in [0,1]}).}

\item{pathnumber}{It represents the number of graph models 
(i.e. \eqn{\lambda}) for the evaluation.The value of pathnumber can be the 
same number used in a penalized path.}
}
\value{
Return the list of assessment results for a series of precision
matrices. The results include sensitivity/specificity/NPV/PPV
}
\description{
The path_result_for_roc function is designed to evaluate the 
the prediction accuracy of a series Gaussian Graphical models (GGM) comparing 
to the true graph structure.
The GGM must use a l-p norm regularizations (p=1,2) with the series of
solutions conditional on the regularization parameter.
}
\examples{
prec1 <- matrix(c(0,2,3,1,0,0.5,0,0,0.4),nrow=3,ncol=3)
Omega_est <- array(dim=c(3,3,3))
Omega_est[,,1] <- matrix(c(0,1,2,1,0.5,0.2,0,1,1),nrow=3,ncol=3)
Omega_est[,,2] <- matrix(c(0,1,0,1,0.5,0.2,0,1,1),nrow=3,ncol=3)
Omega_est[,,3] <- matrix(c(0,1,0,1,0,0.2,0,1,1),nrow=3,ncol=3)
rocpath <- path_result_for_roc(PREC_for_graph=prec1,OMEGA_path=Omega_est,
pathnumber=3)

}
