% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialDE.R
\name{spatialDE}
\alias{spatialDE}
\alias{spatialDE,matrix-method}
\alias{spatialDE,SpatialExperiment-method}
\title{Find spatially variable genes with \strong{SpatialDE}}
\usage{
spatialDE(x, ...)

\S4method{spatialDE}{matrix}(x, coordinates, verbose = FALSE)

\S4method{spatialDE}{SpatialExperiment}(x, assay_type = "counts", verbose = FALSE)
}
\arguments{
\item{x}{A numeric \code{matrix} of counts where genes are rows and cells are columns.

Alternatively, a \linkS4class{SpatialExperiment} object.}

\item{...}{For the generic, arguments to pass to specific methods.}

\item{coordinates}{A \code{data.frame} with sample coordinates. Each row is a
sample, the columns with coordinates should be named 'x' and 'y'.

For the \emph{SpatialExperiment} method, coordinates are taken from
\code{spatialCoords(x)}.}

\item{verbose}{A \code{logical} controlling the display of a progress bar from the
Python package.}

\item{assay_type}{A \code{character} string specifying the assay from \code{x} to use
as input. Defaults to \code{"counts"}.}
}
\value{
A \code{data.frame} with DE results where each row is a gene and columns
contain relevant statistics.

The most important columns are:
\itemize{
\item \code{g}: the name of the gene
\item \code{pval}: the p-value for spatial differential expression
\item \code{qval}: the q-value, indicating significance after correcting for
multiple testing
\item \code{l}: A parameter indicating the distance scale a gene changes expression
over
}
}
\description{
Identify genes that significantly depend on spatial coordinates with the
\href{https://github.com/Teichlab/SpatialDE}{\strong{SpatialDE}} Python package.
}
\examples{
## Mock up a SpatialExperiment object wit 400 cells and 3 genes
set.seed(42)
spe <- mockSVG(size = 20, tot_genes = 3, de_genes = 1, return_SPE = TRUE)

## Run spatialDE
de_results <- spatialDE(spe)

head(de_results)

}
\references{
Svensson, V., Teichmann, S. & Stegle, O. SpatialDE: identification of
spatially variable genes. Nat Methods 15, 343–346 (2018).
\url{https://doi.org/10.1038/nmeth.4636}

\href{https://pypi.org/project/SpatialDE/1.1.3/}{\strong{SpatialDE 1.1.3}}: the version
of the Python package used under the hood.
}
\seealso{
The individual steps performed by this function: \code{\link[=stabilize]{stabilize()}},
\code{\link[=regress_out]{regress_out()}} and \code{\link[=run]{run()}}.

For further analysis of the DE results:
\code{\link[=model_search]{model_search()}} and \code{\link[=spatial_patterns]{spatial_patterns()}}.
}
\author{
Davide Corso, Milan Malfait, Lambda Moses
}
