% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aeh.R
\name{spatialPatterns}
\alias{spatialPatterns}
\alias{spatialPatterns,matrix-method}
\alias{spatialPatterns,SpatialExperiment-method}
\title{Automatic expression histology in \strong{SpatialDE}}
\usage{
spatialPatterns(x, de_results, ...)

\S4method{spatialPatterns}{matrix}(
  x,
  de_results,
  coordinates,
  qval_thresh = 0.05,
  n_patterns,
  length,
  verbose = FALSE
)

\S4method{spatialPatterns}{SpatialExperiment}(
  x,
  de_results,
  qval_thresh = 0.05,
  n_patterns,
  length,
  assay_type = "counts",
  verbose = FALSE
)
}
\arguments{
\item{x}{A numeric \code{matrix} of counts where genes are rows and cells are columns.

Alternatively, a \linkS4class{SpatialExperiment} object.}

\item{de_results}{\code{data.frame} resulting from \code{\link[=run]{run()}} or \code{\link[=spatialDE]{spatialDE()}}.}

\item{...}{For the generic, arguments to pass to specific methods.}

\item{coordinates}{A \code{data.frame} with sample coordinates. Each row is a
sample, the columns with coordinates should be named 'x' and 'y'.

For the \emph{SpatialExperiment} method, coordinates are taken from
\code{spatialCoords(x)}.}

\item{qval_thresh}{\code{numeric} scalar, specifying the q-value significance
threshold to filter \code{de_results}. Only rows in \code{de_results} with
\code{qval < qval_thresh} will be kept. To disable, set \code{qval_thresh = NULL}.}

\item{n_patterns}{\code{integer} The number of spatial patterns}

\item{length}{\code{numeric} The characteristic length scale of the clusters}

\item{verbose}{A \code{logical} controlling the display of a progress bar from the
Python package.}

\item{assay_type}{A \code{character} string specifying the assay from \code{x} to use
as input. Defaults to \code{"counts"}.}
}
\value{
A \code{list} of two \code{data.frame}s (pattern_results, patterns):
\itemize{
\item \code{pattern_results}: \code{data.frame} with pattern membership information for each
gene.
\item \code{patterns} the posterior mean underlying expression from genes in given
spatial patterns.
}
}
\description{
Group spatially variable genes into spatial patterns using Automatic
Expression Histology, using the
\href{https://github.com/Teichlab/SpatialDE}{\strong{SpatialDE}} Python package.
}
\examples{
## Mock up a SpatialExperiment object wit 100 cells and 3 genes
set.seed(42)
spe <- mockSVG(size = 10, tot_genes = 3, de_genes = 1, return_SPE = TRUE)

## Run spatialDE
de_results <- spatialDE(spe)

spatial_patterns <- spatialPatterns(spe, de_results = de_results,
    qval_thresh = NULL, n_patterns = 4L, length = 1.5,
    verbose = FALSE
)

head(spatial_patterns$pattern_results)
head(spatial_patterns$patterns)

}
\references{
Svensson, V., Teichmann, S. & Stegle, O. SpatialDE: identification of
spatially variable genes. Nat Methods 15, 343–346 (2018).
\url{https://doi.org/10.1038/nmeth.4636}

\href{https://pypi.org/project/SpatialDE/1.1.3/}{\strong{SpatialDE 1.1.3}}: the version
of the Python package used under the hood.
}
\seealso{
The individual steps performed by this function: \code{\link[=stabilize]{stabilize()}},
\code{\link[=regress_out]{regress_out()}} and \code{\link[=spatial_patterns]{spatial_patterns()}}.
}
\author{
Davide Corso, Milan Malfait, Lambda Moses
}
