% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_binned_coverage.R
\name{get_binned_coverage}
\alias{get_binned_coverage}
\title{tabulate read coverage in predefined bins}
\usage{
get_binned_coverage(bins, covg)
}
\arguments{
\item{bins}{the GRanges with bins}

\item{covg}{the coverage result (an RleList)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   a GRanges of summarized coverage
}\if{html}{\out{</div>}}
}
\description{
refactored out of scan_spiked_bam
}
\examples{
sb <- system.file("extdata", "example.spike.bam", package="spiky",
                   mustWork=TRUE)
data(spike,package="spiky")
si <- seqinfo_from_header(sb)
genome(si) <- "spike"
mgr <- get_merged_gr(si,spike=spike)
fl <- scanBamFlag(isDuplicate=FALSE, isPaired=TRUE, isProperPair=TRUE)
bp <- ScanBamParam(flag=fl)
bamMapqFilter(bp) <- 20

covg <- get_spiked_coverage(sb, bp=bp, gr=mgr)
get_binned_coverage(bins=GRanges(), covg=covg)

}
\seealso{
\if{html}{\out{<div class="sourceCode">}}\preformatted{  get_spiked_coverage
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{  scan_spiked_bam
}\if{html}{\out{</div>}}
}
