% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squallms-package.R
\docType{package}
\name{squallms-package}
\alias{squallms}
\alias{squallms-package}
\title{squallms: Speedy quality assurance via lasso labeling for LC-MS data}
\description{
squallms is a Bioconductor R package that implements a "semi-labeled" approach to untargeted mass spectrometry data. It pulls in raw data from mass-spec files to calculate several metrics that are then used to label MS features in bulk as high or low quality. These metrics of peak quality are then passed to a simple logistic model that produces a fully-labeled dataset suitable for downstream analysis.
}
\details{
squallms is an R package that allows for the identification and removal of
low-quality chromatographic features from mass-spectrometry data. This
process involves three steps: first, the calculation of peak quality
metrics via \code{\link[=extractChromMetrics]{extractChromMetrics()}}; second, labeling of high and low quality
features either one at a time with \code{\link[=labelFeatsManual]{labelFeatsManual()}} or in bulk with
\code{\link[=labelFeatsLasso]{labelFeatsLasso()}}; and finally, probabilistic model construction using
\code{\link[=logModelFeatQuality]{logModelFeatQuality()}}.

The package interfaces neatly with XCMS, providing two additional functions
that turn an XCMS object into a flat file (\code{\link[=makeXcmsObjFlat]{makeXcmsObjFlat()}}) and edit
the XCMS object's feature list to contain only high quality features
(\code{\link[=updateXcmsObjFeats]{updateXcmsObjFeats()}}). Data can be provided without using XCMS if it
is properly formatted (see the help pages).

See the package intro on GitHub at https://github.com/wkumler/squallms and
explore the vignettes with \code{vignette("intro_to_squallms", package = "squallms")}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/wkumler/squallms}
  \item Report bugs at \url{https://github.com/wkumler/squallms/issues}
}

}
\author{
\strong{Maintainer}: William Kumler \email{wkumler@uw.edu} (\href{https://orcid.org/0000-0002-5022-8009}{ORCID}) [copyright holder]

}
\keyword{internal}
