% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zscoreHeatmap.R
\name{zscoreMatrix}
\alias{zscoreMatrix}
\title{Generate Z-score matrix}
\usage{
zscoreMatrix(sampleInfo, joincount.result)
}
\arguments{
\item{sampleInfo}{A data.frame contains the pixel information and cluster labels for each barcode of a human breast cancer sample.
The index contains barcodes, and at least three other columns that have these information are required and the column names should be the same as following:
"imagerow": The row pixel coordinate of the center of the spot
"imagecol": The column pixel coordinate of the center of the spot
"Cluster": The label that corresponding to this barcode}

\item{joincount.result}{calculated result from join count analysis}
}
\value{
A data.frame that has a z-score matrix resulting from the join count analysis for all possible label pairs
}
\description{
This function provides a heatmap of z-scores resulting
from the join count analysis for all possible label pairs.
}
\examples{
fpath <- system.file("extdata", "dataframe.rda", package="stJoincount")
load(fpath)
mosaicIntegration <- rasterizeEachCluster(humanBC)
joincount.result <- joincountAnalysis(mosaicIntegration)
matrix <- zscoreMatrix(humanBC, joincount.result)
}
