% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftCor_combat.R
\name{shiftCor_dQC (deprecated)}
\alias{shiftCor_dQC (deprecated)}
\alias{shiftCor_dQC}
\title{QC-free based signal correction}
\usage{
shiftCor_dQC(
  samPeno,
  samFile,
  Frule = 0.8,
  imputeM = "KNN",
  MLmethod = "Combat",
  par.prior = TRUE,
  prior.plots = FALSE,
  mod.covariates = FALSE,
  batch.Num = NULL
)
}
\arguments{
\item{samPeno}{The file with the meta information including the sample name,
batches, class and order (denoting other covariates besides batch).}

\item{samFile}{The file with the expression information.}

\item{Frule}{Modified n precent rule function. A variable will be kept if it has a non-zero value
for at least n precent of samples in any one group. 
(Default: 0.8)}

\item{imputeM}{The parameter for imputation method i.e., nearest neighbor 
averaging, 'KNN'; minimum values, 'min'; Half of minimum values, 'minHalf'; 
median values, 'median'.}

\item{MLmethod}{'ComBat' allows users to adjust for batch effects in datasets where the batch covariate is known, using methodology
described in Johnson et al. 2007. It uses either parametric or non-parametric empirical Bayes frameworks for adjusting data for
batch effects.  Users are returned an expression matrix that has been corrected for batch effects.The function was revised accroding to 'sva' package (version = "3.8").}

\item{par.prior}{TRUE indicates parametric adjustments will be used, FALSE indicates non-parametric adjustments will be used}

\item{prior.plots}{(Optional) TRUE give prior plots.}

\item{mod.covariates}{TRUE indicates model matrix for outcome of interest and other covariates besides batch (Column 'order' denotes covariates the  in samPeno file).}

\item{batch.Num}{(Optional) NULL If given, will use the selected batch as a reference for batch adjustment.}
}
\value{
the shiftCor files. See the details at https://stattarget.github.io
}
\description{
shiftCor_dQC provides the QC-free based signal correction for 
large scale mass spectrometry-based omics data.
}
\examples{
datpath <- system.file('extdata',package = 'statTarget')
samPeno <- paste(datpath,'MTBLS79_dQC_sampleList.csv', sep='/')
samFile <- paste(datpath,'MTBLS79.csv', sep='/')
shiftCor_dQC(samPeno,samFile, Frule = 0.8, MLmethod = "Combat",mod.covariates = FALSE)
shiftCor_dQC(samPeno,samFile, Frule = 0.8, MLmethod = "Combat",mod.covariates = TRUE,batch.Num = 1)
}
\keyword{Controls,Correction}
\keyword{Quality}
