% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFA_class.R
\name{dfa_scores_plot}
\alias{dfa_scores_plot}
\title{DFA scores plot}
\usage{
dfa_scores_plot(
  components = c(1, 2),
  points_to_label = "none",
  factor_name,
  ellipse = "all",
  label_filter = character(0),
  label_factor = "rownames",
  label_size = 3.88,
  ...
)
}
\arguments{
\item{components}{(numeric) The components selected for plotting. The default is \code{c(1, 2)}.}

\item{points_to_label}{(character) Points to label. Allowed values are limited to the following: \itemize{ \item{\code{"none"}: No samples labels are displayed.}\item{\code{"all"}: The labels for all samples are displayed.}\item{\code{"outliers"}: Labels for for potential outlier samples are displayed.}} The default is \code{"none"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{ellipse}{(character) Plot ellipses. Allowed values are limited to the following: \itemize{ \item{\code{"all"}: Hotelling T2 ellipses (p=0.95) are plotted for all groups and all samples.}\item{\code{"group"}: Hotelling T2 ellipses (p=0.95) are plotted for all groups.}\item{\code{"none"}: Ellipses are not included on the plot.}\item{\code{"sample"}: A Hotelling T2 ellipse (p=0.95) is plotted for all samples (ignoring group).}} The default is \code{"all"}.}

\item{label_filter}{(character) Labels are only plotted for the named groups. If zero-length then all groups are included. The default is \code{character(0)}.}

\item{label_factor}{(character) The column name of sample_meta to use for labelling samples on the plot. "rownames" will use the row names from sample_meta. The default is \code{"rownames"}.}

\item{label_size}{(numeric) The text size of labels. Note this is not in Font Units. The default is \code{3.88}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
dfa_scores_plot
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A scatter plot of the selected DFA components.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{scales}} \item{\code{ggplot2}}}
}
\section{Inheritance}{

A \code{dfa_scores_plot} object inherits the following \code{struct} classes: \cr\cr
\verb{[dfa_scores_plot]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = dfa_scores_plot(
      components = c(1, 2),
      points_to_label = "none",
      factor_name = "V1",
      ellipse = "all",
      label_filter = character(0),
      label_factor = "rownames",
      label_size = 3.88)

D = iris_DatasetExperiment()
M = mean_centre() + DFA(factor_name='Species')
M = model_apply(M,D)
C = dfa_scores_plot(factor_name = 'Species')
chart_plot(C,M[2])

}
\references{
Wickham H, Pedersen T, Seidel D (2023). \emph{scales: Scale Functions for
Visualization}. R package version 1.3.0,
\url{https://CRAN.R-project.org/package=scales}.

Wickham H (2016). \emph{ggplot2: Elegant Graphics for Data Analysis}.
Springer-Verlag New York. ISBN 978-3-319-24277-4,
\url{https://ggplot2.tidyverse.org}.
}
