% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glog_class.R
\name{glog_opt_plot}
\alias{glog_opt_plot}
\title{Glog optimisation}
\usage{
glog_opt_plot(plot_grid = 100, ...)
}
\arguments{
\item{plot_grid}{(numeric)  The default is \code{100}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
glog_opt_plot
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A plot of the sum of squares error (SSE) vs different values of lambda for the glog transform. The indicated optimum value for lambda minimises the SSE.
}
\details{
This object makes use of functionality from the following packages:\itemize{  \item{\code{pmp}}}
}
\section{Inheritance}{

A \code{glog_opt_plot} object inherits the following \code{struct} classes: \cr\cr
\verb{[glog_opt_plot]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = glog_opt_plot(
      plot_grid = numeric(0))

D = iris_DatasetExperiment()
M = glog_transform(qc_label='versicolor',factor_name='Species')
M = model_apply(M,D)
C = glog_opt_plot()
chart_plot(C,M,D)
}
\references{
Jankevics A, Lloyd GR, Weber RJM (????). \emph{pmp: Peak Matrix Processing
and signal batch correction for metabolomics datasets}. R package
version 1.15.1.
}
