% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairs_filter_class.R
\name{pairs_filter}
\alias{pairs_filter}
\title{Pairs filter}
\usage{
pairs_filter(factor_name, sample_id, ...)
}
\arguments{
\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{sample_id}{(character) Name of sample meta column containing sample identifiers.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{pairs_filter} object with the following \code{output} slots:
\tabular{ll}{
\code{filtered} \tab          (DatasetExperiment) A DatasetExperiment object after the filter has been applied. \cr
\code{flags} \tab          (data.frame) A data.frame indicating whether features were filtered from the DatasetExperiment. \cr
}

struct object
}
\description{
This filter is used for study designs with paired sampling to ensure that  measurements from the same source (e.g. patient) are represented in all factor levels and interactions.
}
\section{Inheritance}{

A \code{pairs_filter} object inherits the following \code{struct} classes: \cr\cr
\verb{[pairs_filter]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = pairs_filter(
      factor_name = "V1",
      sample_id = "V1")

M=pairs_filter(factor_name='Class',sample_id='ids')
}
