% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multi_drugs.R
\name{DimensionReduction}
\alias{DimensionReduction}
\title{Dimension Reduction for Multi-drug Combination Visualization}
\usage{
DimensionReduction(
  plot_table,
  drug_pair,
  plot_value,
  distance_method = "mahalanobis"
)
}
\arguments{
\item{plot_table}{A data frame contains concentrations for all drugs, the
values for \code{plot_value}.}

\item{drug_pair}{A data frame contains the drug names and concentration
unites, whither the block is replicate or not.}

\item{plot_value}{A vector of characters. It contains the name of one or more
metrics to be visualized. If the \code{data} is the direct output from 
\link{ReshapeData}, the values for this parameter are:
\itemize{
  \item \strong{response_origin} The original response value in input data.
  It might be \% inhibition or \% viability.
  \item \strong{response} The \% inhibition after preprocess by function 
  \link{ReshapeData}
}
If the \code{data} is the output from \link{CalculateSynergy}, following
values are also available:
\itemize{
  \item \strong{ZIP_ref, Bliss_ref, HSA_ref, Loewe_ref} The reference
  additive effects calculated by ZIP, Bliss, HSA or Loewe model,
  respectively.
  \item \strong{ZIP_synergy, Bliss_synergy, HSA_synergy, Loewe_synergy}
  The synergy score calculated by ZIP, Bliss, HSA or Loewe model,
  respectively.
  \item \strong{ZIP_fit} The response fitted by ZIP model.
}}

\item{distance_method}{The methods to calculate the distance between
different data points from the concentration of drugs. The distance matrix
is used for dimension reduction. This parameter is used to set the 
parameter \code{method} for \link[vegan]{vegdist}. The default values is
"mahalanobis".}
}
\value{
A data frame. It contains the plot information required by function
  \link{GenerateSurface}
}
\description{
This function will take the multi-drug combination data, project the
concentrations of all the drugs into 2 dimensions. It is an auxiliary
function for \link{PlotMultiDrugSurface}
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
