% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_wrapper.R
\name{PlotSynergy}
\alias{PlotSynergy}
\title{Plot Interaction Landscape for Synergy Scores}
\usage{
PlotSynergy(
  data,
  type = "2D",
  method = "ZIP",
  block_ids = c(1),
  drugs = c(1, 2),
  row_range = NULL,
  col_range = NULL,
  color_range = NULL,
  z_range = NULL,
  axis_line = FALSE,
  statistic = NULL,
  summary_statistic = "mean",
  plot_title = NULL,
  interpolate_len = 3,
  high_value_color = "#FF0000",
  low_value_color = "#00FF00",
  text_size_scale = 1,
  heatmap_text_label_size_scale = 1,
  heatmap_text_label_color = "#000000",
  grid = TRUE,
  dynamic = FALSE,
  display = TRUE,
  save_file = FALSE,
  file_type = "pdf",
  file_name = NULL,
  file_path = NULL,
  height = 6,
  width = 6,
  units = "in"
)
}
\arguments{
\item{data}{A list object generated by function
\code{\link{CalculateSynergy}}}

\item{type}{A character value. It specifies the type of the plot. Available
values are:
\itemize{
  \item \strong{2D} Visualize 2D interactive landscape with contour plot.
  \item \strong{heatmap} Heatmap for synergy scores.
  \item \strong{3D} Visualize 3D surface for interactive landscape.
}}

\item{method}{A character value. It indicates which synergy score to be 
visualized. Available values are "ZIP", "HSA", "Bliss", or "Loewe".}

\item{block_ids}{A parameter to specify which drug combination if there are 
many drug combinations in the data. By default, it is NULL so that the 
synergy score visualization of all the drug combinations in the data is 
returned.}

\item{drugs}{A vector of characters or integers with length of 2. It contains
the index for two drugs to plot. For example, \code{c(1, 2)} indicates to
plot "drug1" and "drug2" in the input \code{data}.}

\item{row_range}{A vector of two integers. They specify the starting and
ending concentration of the drug on y-axis. Use e.g., c(1, 3) to specify
that only from 1st to 3rd concentrations of the drug on y-axis are used. By
default, it is NULl so all the concentrations are used.}

\item{col_range}{A vector of two integers. They specify the starting and 
ending concentration of the drug on x-axis. Use e.g., c(1, 3) to specify
that only from 1st to 3rd concentrations of the drug on x-axis are used. By
default, it is NULl so all the concentrations are used.}

\item{color_range}{A vector of two numeric values. They specify the range
of the color bars. The first item (lower bounder) must be less than the
second one (upper bounder). The plotted values larger than defined upper
bounder will be filled in color \code{high_value_color}. The plotted values
less than defined lower bounder will be filled in color
\code{low_value_color}. If the defined range includes 0, value 0 will be
filled in color "white". By default, it is set as \code{NULL} which
means the function will automatically set the color range according to
the plotted values.}

\item{z_range}{A vector of two numeric values. They specify the range of
z-axis plotted in 3D surface plot. It doesn't work for 2D or heatmap plots.
Default value is \code{NULL}. The function automatically set the range.}

\item{axis_line}{A logical value. Whether to show the axis lines and ticks.
It doesn't work for heatmap plot.}

\item{statistic}{A character or NULL. It indicates the statistics printed
in the plot while there are replicates in input data. Available values are:
\itemize{
  \item \strong{sem} Standard error of mean;
  \item \strong{ci} 95\% confidence interval.
}
If it is \code{NULL}, no statistics will be printed. \strong{Note}: It only
works in Heatmap plot.}

\item{summary_statistic}{A vector of characters or NULL. It indicates the
summary statistics for all the \code{plot_value} in whole combination
matrix. Available values are:
\itemize{
  \item \strong{mean} Median value for all the responses or synergy
  scores in the matrix and the p-value if it is valid;
  \item \strong{median} Median value for all the responses or synergy
  scores in the matrix;
  \item \strong{quantile_90} 90\% quantile. User could change the number to
  print different sample quantile. For example quantile_50 equal to median. 
}
If it is \code{NULL}, no statistics will be printed.}

\item{plot_title}{A character value. It specifies the plot title. If it is
\code{NULL}, the function will automatically generate a title.}

\item{interpolate_len}{An integer. It specifies how many values need to be
interpolated between two concentrations. It is used to control the 
smoothness of the synergy surface in the contour plot and surface plot.
\strong{Note}: It only works in 2D and 3D plots.}

\item{high_value_color}{An R color value. It indicates the color for the
high values.}

\item{low_value_color}{An R color value. It indicates the color for low
values.}

\item{text_size_scale}{A numeric value. It is used to control the size
of text in the plot. All the text size will multiply by this scale factor.}

\item{heatmap_text_label_size_scale}{A numeric value. It is used to control
the size of text labels in the heatmap plot. It only works while 
\code{plot_type = "heatmap"}.}

\item{heatmap_text_label_color}{NULL or an R color value. It is used to
control the color of text labels in the heatmap plot. If it is \code{NULL},
text label will not be shown. It only works while
\code{plot_type = "heatmap"}.}

\item{grid}{A logical value. It indicates whether to add grids on the pot.
It only works while \code{plot_type = "3D"} or \code{plot_type = "2D"}.}

\item{dynamic}{A logic value. It indicates whether to generate interactive
plot wit package "plotly" or static plot with package "ggplot2"/"lattice".}

\item{display}{A logic value. It specifies whether to automatically display
plots while calling the function.}

\item{save_file}{A logic value. It specifies if the interaction landscapes
is saved by calling \link[ggplot2]{ggsave} function ("2D" or "heatmap"
plots) or plot saving function defined by \code{device} ("3D" plots). By
default, it is FALSE. \strong{Note}: It doesn't work while
\code{dynamic = TRUE}, because installation of "Orca" is required for
exporting plotly plots. Please check 
https://plotly.com/r/static-image-export/ for more details.}

\item{file_type}{A character value. It indicates the device to use for saving 
plots. If \code{type = "3D"}, the corresponding device function in package
"grDevices" will be called to save the plots. If
\code{type = "2D"/"heatmap"}, it will be used to set the parameter
\code{device} in function \link[ggplot2]{ggsave}.
\strong{Note}: It only works while \code{save_file = TRUE}.}

\item{file_name}{A character vector. It indicates the file names. If it is 
not defined by user, a default name will be assigned. \strong{Note}: It
only works while \code{save_file = TRUE}.}

\item{file_path}{A character vector. It indicates the path to save file.
If it is not defined by user, a default name will be assigned. 
\strong{Note}: It only works while \code{save_file = TRUE}.}

\item{height}{A numeric value. It indicates the height of the output plot.
\strong{Note}: It only works while \code{save_file = TRUE}.}

\item{width}{A numeric value. It indicates the width of the output plot.
\strong{Note}: It only works while \code{save_file = TRUE}.}

\item{units}{A character value. It indicates the units for \code{width} and
\code{height} for saved plots. It is used to set the \code{units}
parameter in function \link[ggplot2]{ggsave} or the function selected by
\code{file_type} (It will not work on "pdf" and "svg" devices. There units
are always in inch.). \strong{Note}: It only works while 
\code{save_file = TRUE}.}
}
\value{
A list of ggplot objects.
}
\description{
A function to visualize the synergy scores for drug combinations as 2D or 3D
interaction landscape over the dose-response matrix.
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
data <- CalculateSynergy(data)
plots <- PlotSynergy(data, "2D", block_ids = NULL)
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
