% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_microsynteny-based_phylogeny.R
\name{infer_microsynteny_phylogeny}
\alias{infer_microsynteny_phylogeny}
\title{Infer microsynteny-based phylogeny with IQTREE}
\usage{
infer_microsynteny_phylogeny(
  transposed_profiles = NULL,
  bootr = 1000,
  alrtboot = 1000,
  threads = "AUTO",
  model = "MK+FO+R",
  outdir = tempdir(),
  outgroup = NULL,
  verbose = FALSE
)
}
\arguments{
\item{transposed_profiles}{A binary and transposed profile matrix.
The profile matrix can be obtained with \code{phylogenomic_profile()}.}

\item{bootr}{Numeric scalar with the number of bootstrap replicates.
Default: 1000.}

\item{alrtboot}{Numeric scalar with the number of replicates for
the SH-like approximate likelihood ratio test. Default: 1000.}

\item{threads}{Numeric scalar indicating the number of threads to use or
"AUTO", which allows IQTREE to automatically choose the best number
of threads to use. Default: "AUTO".}

\item{model}{Substitution model to use. If you are unsure, pick the default.
Default: "MK+FO+R".}

\item{outdir}{Path to output directory. By default, files are saved in
a temporary directory, so they will be deleted when the R session closes.
If you want to keep the files, specify a custom output directory.}

\item{outgroup}{Name of outgroup clade to group the phylogeny.
Default: NULL (unrooted phylogeny).}

\item{verbose}{Logical indicating if progress messages should be prompted.
Default: FALSE.}
}
\value{
A character vector of paths to output files.
}
\description{
Infer microsynteny-based phylogeny with IQTREE
}
\examples{
data(clusters)
profile_matrix <- phylogenomic_profile(clusters)
tmat <- binarize_and_transpose(profile_matrix)

# Leave only some legumes and P. mume as an outgroup for testing purposes
included <- c("gma", "pvu", "vra", "van", "cca", "pmu")
tmat <- tmat[rownames(tmat) \%in\% included, ]

# Remove non-variable sites
tmat <- tmat[, colSums(tmat) != length(included)]

if(iqtree_is_installed()) {
    phylo <- infer_microsynteny_phylogeny(tmat, outgroup = "pmu", 
                                          threads = 1)
}
 
}
