% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_helpers.R
\name{check_matching_colnames}
\alias{check_matching_colnames}
\title{Check if two data frames have the same column names}
\usage{
check_matching_colnames(df1, df2)
}
\arguments{
\item{df1}{A dataframe.}

\item{df2}{A dataframe.}
}
\value{
NULL. Throws an error if column names do not match.
}
\description{
This function verifies that two data frames (RIBO and RNA) contain
the same set of column names, regardless of their order.
This is important for how terapadog handles these matching samples during
shuffles.
}
\examples{
#' # Internal function, code cannot be run from here.
\dontrun{
rna_file <- system.file("extdata", "rna_counts.tsv",
package = "terapadog")
ribo_file <- system.file("extdata", "ribo_counts.tsv",
package = "terapadog")
rna_df <- read.table(rna_file, header = TRUE, sep = "\t")
ribo_df <- read.table(ribo_file, header = TRUE, sep = "\t")
check_matching_colnames(rna_df, ribo_df)
}
}
\keyword{internal}
