% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDTA.R
\name{plotDTA}
\alias{plotDTA}
\title{This function will plot an interactive html plot of the results of get_FCs.R
That is to say, a plot of the genes undergoing translational regulation,
coloured by RegMode.
Genes whose RegMode was Undeterminable or Undetermined are omitted.}
\usage{
plotDTA(
  FC_results,
  save_plot = FALSE,
  path = file.path(tempdir(), "plot.html")
)
}
\arguments{
\item{FC_results}{A dataframe containing the counts from RNA and RIBO
samples.}

\item{save_plot}{Boolean. Default is FALSE. If TRUE, will save plot to a specified
directory or a temporary one if none are given.}

\item{path}{A string, pointing to where to save the html plot. If none is
given, the plot will be saved to a temporary directory. This parameter will be
ignored if save_plot is set to FALSE.}
}
\value{
An interactive html plot.
}
\description{
This function will plot an interactive html plot of the results of get_FCs.R
That is to say, a plot of the genes undergoing translational regulation,
coloured by RegMode.
Genes whose RegMode was Undeterminable or Undetermined are omitted.
}
\examples{
# Creates a mock dataframe for this demonstration
df <- data.frame(
  Identifier = c("Gene A", "Gene B", "Gene C", "Gene D"),
  RegMode = c("Buffered", "Exclusive", "Undeterminable", "No Change"),
  RNA_FC = c(-0.40, -0.5, NA, 0.01),
  RIBO_FC = c(0.19, -0.3, 0.8, -0.02)
)
result <- plotDTA(df)
}
