% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terraTCGAdata.R
\name{getAssayData}
\alias{getAssayData}
\title{Obtain assay datasets from Terra}
\usage{
getAssayData(
  assayName,
  sampleCode = "01",
  tablename = .DEFAULT_TABLENAME,
  workspace = terraTCGAworkspace(),
  namespace = .DEFAULT_NAMESPACE,
  metacols = .PARTICIPANT_METADATA_COLS,
  sampleIdx = TRUE
)
}
\arguments{
\item{assayName}{character() The name of the assay dataset column from
\code{getAssayTable} to import into the current workspace.}

\item{sampleCode}{character(1) The sample code used to filtering samples
e.g., "01" for Primary Solid Tumors, see
\code{data("sampleTypes", package = "TCGAutils")} for reference}

\item{tablename}{The Terra data model table from which to extract the
clinical data (default: "sample")}

\item{workspace}{character(1) The Terra Data Resources workspace from which
to pull TCGA data (default: see \code{terraTCGAworkspace()}). This is set to a
package-wide option.}

\item{namespace}{character(1) The Terra Workspace Namespace that
defaults to "broad-firecloud-tcga" and rarely needs to be changed.}

\item{metacols}{The set of columns that comprise of the metadata columns.
See the \code{.PARTICIPANT_METADATA_COLS} global variable}

\item{sampleIdx}{numeric() index or TRUE. Specify an index for subsetting the
assay data. This argument is mainly used for example and vignette
purposes. To use all the data, use the default value (default: \code{TRUE})}
}
\value{
Either a matrix or RaggedExperiment depending on the assay selected
}
\description{
Obtain assay datasets from Terra
}
\examples{
if (
    AnVILGCP::gcloud_exists() &&
    identical(AnVILBase::avplatform_namespace(), "AnVILGCP") &&
    nzchar(AnVILGCP::avworkspace_name())
)
  getAssayData(
      assayName = "protein_exp__mda_rppa_core__mdanderson_org__Level_3__protein_normalization__data",
      sampleCode = c("01", "10"),
      workspace = "TCGA_ACC_OpenAccess_V1-0_DATA"
  )

}
\seealso{
\code{\link[=getAssayTable]{getAssayTable()}}
}
