% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{join_features}
\alias{join_features}
\alias{join_features,SingleCellExperiment-method}
\title{join_features}
\usage{
\S4method{join_features}{SingleCellExperiment}(
  .data,
  features = NULL,
  all = FALSE,
  exclude_zeros = FALSE,
  shape = "wide",
  ...
)
}
\arguments{
\item{.data}{A tidy SingleCellExperiment object}

\item{features}{A vector of feature identifiers to join}

\item{all}{If TRUE return all}

\item{exclude_zeros}{If TRUE exclude zero values}

\item{shape}{Format of the returned table "long" or "wide"}

\item{...}{Parameters to pass to join wide, i.e. assay name to extract feature abundance from and gene prefix, for shape="wide"}
}
\value{
A `tidySingleCellExperiment` object
  containing information for the specified features.
}
\description{
join_features() extracts and joins information for specific
  features
}
\details{
This function extracts information for specified features and
  returns the information in either long or wide format.
}
\examples{
data(pbmc_small)
pbmc_small \%>\% join_features(
  features=c("HLA-DRA", "LYZ"))

}
\references{
Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2
}
