% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_dimensions.R
\name{.rotate_dimensions_se}
\alias{.rotate_dimensions_se}
\title{Rotate two coordinate columns and append the rotated axes}
\usage{
.rotate_dimensions_se(
  .data,
  dimension_1_column,
  dimension_2_column,
  rotation_degrees,
  .element = NULL,
  of_samples = TRUE,
  dimension_1_column_rotated = NULL,
  dimension_2_column_rotated = NULL
)
}
\arguments{
\item{.data}{A `SummarizedExperiment` (or derivative) holding the
coordinates to be rotated.}

\item{dimension_1_column}{Symbol or bare column name for the first axis
(e.g. `UMAP_1`).}

\item{dimension_2_column}{Symbol or bare column name for the second axis
(e.g. `UMAP_2`).}

\item{rotation_degrees}{Numeric scalar in the closed interval
\([-360, 360]\) indicating the anti-clockwise rotation
angle.}

\item{.element}{Optional quoted column holding sample or feature labels
(unused, retained for compatibility).}

\item{of_samples}{Logical.  If `TRUE` (default) the function rotates
columns in `colData()`.  If `FALSE` it operates on
`rowData()`.}

\item{dimension_1_column_rotated}{Optional symbol to name the new first
rotated coordinate column.}

\item{dimension_2_column_rotated}{Optional symbol to name the new second
rotated coordinate column.}
}
\value{
The input `SummarizedExperiment` with two extra metadata columns
        containing the rotated axes.
}
\description{
This internal helper applies a planar rotation to two numeric columns
that represent a low-dimensional embedding (for example PCA or UMAP
coordinates) stored in either `colData()` or `rowData()` of a
`SummarizedExperiment`.  It returns the original object with two
additional columns containing the rotated values.  The user specifies
the rotation angle in degrees and may provide custom names for the new
columns; otherwise sensible defaults are generated.
}
\keyword{internal}
